CREATE OR REPLACE FUNCTION TSystem.views__ReportingAnfrage__recreate() RETURNS void AS $$
  BEGIN

      DROP VIEW IF EXISTS treporting.anfrage_anfart_positionen;

      CREATE OR REPLACE VIEW treporting.anfrage_anfart_positionen AS
      SELECT
          'anfart'::varchar(30)                                         AS position_tablename,
          anfart.dbrid                                                  AS position_dbrid,
          aart_id                                                       AS position_id,
          aart_id                                                       AS position_abzu_join_id,
          null::char(1)                                                 AS position_status,
          aart_anf_nr                                                   AS position_identnummer,
          aart_pos                                                      AS position_identpos,

          -- nicht direkt vorhanden, evtl späer -> in liste current_date
          anfrage.insert_date                                           AS datum_erfasst,

          null::date                                                    AS referenz_identdatum,
          aart_pos                                                      AS position_coalesce_handwerker_posnr,

          -- rechnung : 2. referenz ist auftrag, aus dem der lieferschein war
          null::char(1)                                                 AS position_status1,
          null::char(1)                                                 AS position_identnummer1,
          null::integer                                                 AS position_identpos1,

          alief_id                                                      AS position_dokument_id,
          false                                                         AS position_israhmenabruf,
          null::char(1)                                                 AS position_rahmen_nr_referenz,
          null::integer                                                 AS position_rahmen_abrufnr,

          -- aart_ref
          null::char(1)                                                 AS referenz,
          null::integer                                                 AS referenz_pos,
          null::date                                                    AS referenz_vondatum,

          -- Lieferschein: Menge Bestellt (Verkauf an Kunde)
          null::float                                                   AS referenz_menge,

          -- Lieferschein: Menge bereits geliefert
          null::float                                                   AS referenz_menge_erledigt,

          aart_ak_nr                                                    AS artikelnummer,
          aart_aknr_idx                                                 AS artikelnummer_index,

          ak_znr                                                        AS artikel_zeichnungsnummer,
          ak_din                                                        AS artikel_materialnorm,

          coalesce(
              tartikel.me__menge__in__menge_uf1(
                  artmgc.m_id,
                  aart_menge
              ),
              aart_menge
          ) * ak_gewicht                                                AS artikel_pos_gewicht,

          null::float                                                   AS artikel_kost_rust,
          null::float                                                   AS artikel_kost_fert,
          null::float                                                   AS artikel_kost_mat,
          null::float                                                   AS artikel_kost_aw,
          null::char(1)                                                 AS artikel_warencode,
          ak_fertigung                                                  AS artikel_fert,
          null::char(1)                                                 AS artikel_ursprung,

          false                                                         AS done,
          false                                                         AS storno,
          false                                                         AS optional,

          null::float                                                   AS kurs_waer,
          null::float                                                   AS preis_me_netto,

          -- siehe Tickets 6447, 6772
          null::float                                                   AS preiseinheit,
          null::float                                                   AS preis_me_netto_uf1,
          null::float                                                   AS preis_me_netto_basis_w,
          null::float                                                   AS preis_me_netto_basis_w_uf1,

          -- siehe Ticket 7678
          null::float                                                   AS preis_mengeneinheit_artmgc_id,

          -- siehe Ticket 7678
          null::char(1)                                                 AS preis_mengeneinheit_bez_iso,
          null::float                                                   AS preis_inkl_rabatt_abzu,
          null::float                                                   AS preis_inkl_rabatt_abzu_steuer,
          null::float                                                   AS preis_me_inkl_posrabatt_ohne_abzu,
          null::float                                                   AS preis_me_inkl_rabatt_ohne_abzu,
          null::float                                                   AS preis_positionswert_nur_hauptpos_werthaltig,
          null::float                                                   AS preis_pos_abzusum,

          false                                                         AS poshatvkp,

          null::float                                                   AS steuproz,

          aart_menge                                                    AS menge,

          -- 7678 Umrechnungsfaktor: 1 Einheit der Menge entspricht 1 Einheit der Menge des Preises
          null::float                                                   AS menge_1in_preiseinheit,
          anfart.aart_los                                               AS menge_rahmen_abrlos,
          coalesce(
              tartikel.me__menge__in__menge_uf1(
                  artmgc.m_id,
                  aart_menge
              ),
              aart_menge
          )                                                             AS menge_uf1,
          null::float                                                   AS menge_geliefert_uf1,

          -- Anzahlungsmenge in richtiger Rechnung?
          null::float                                                   AS menge_verrechnet,
          null::float                                                   AS menge_offen_uf1,
          null::float                                                   AS rabatt,
          null::varchar                                                 AS rabatt_hint,
          null::float                                                   AS rabatt_ges,
          m_id                                                          AS mengeneinheit_artmgc_id,

          coalesce(
              lang_artmgc_id_iso(
                  m_id,
                  ReportLang_current()
              ),
              me_iso
          )                                                             AS mengeneinheit_bez_iso,

          coalesce(
              ifthen(
                  trim( aart_txt_rtf ) = '',
                  null::text,
                  aart_txt_rtf
              ),
              aart_txt
          )::text                                                       AS postxt_rtf,

          null::char(1)                                                 AS an_nr,
          null::char(1)                                                 AS an_bez,

          aart_termin                                                   AS datum_geplant,
          null::date                                                    AS datum_bestaetigt,
          aart_termin                                                   AS datum_coalesce_bestaetigt_geplant,
          null::char(1)                                                 AS datum_text,
          null::date                                                    AS datum_woche_geplant,
          null::date                                                    AS datum_woche_bestaetigt,
          aart_termweek                                                 AS datum_woche,
          null::date                                                    AS datum_auslieferung

      FROM anfart
      JOIN anfrage ON anf_nr = aart_anf_nr
      JOIN anflief ON (   alief_id = ANY(aart_alief_id)
                       OR aart_alief_id IS null )
                  AND alief_anf_nr = anf_nr
      LEFT JOIN art ON ak_nr = aart_ak_nr
      LEFT JOIN mgcode ON me_cod = aart_m_id
      LEFT JOIN artmgc ON m_ak_nr = aart_ak_nr AND m_mgcode = me_cod
      ORDER BY aart_pos
    ;



    DROP VIEW IF EXISTS treporting.anfrage_kopfdaten;


    CREATE OR REPLACE VIEW treporting.anfrage_kopfdaten AS
    SELECT
        anf_nr                                                       AS dokument_id,
        alief_id                                                     AS dokument_join_id,
        anf_nr                                                       AS dokument_nummer,
        anflief.dbrid                                                AS dokument_dms_id,

        null::NUMERIC                                                AS dokument_anzahlprozent,
        null::varchar(10)                                            AS dokument_status,
        false                                                        AS dokument_multidok,

        -- kalkulationsanfrage, ist nur "provisorische" -> nicht definitiv
        NOT anf_kalk                                                 AS definitiv,

        'bestanf'::varchar(10)                                       AS doktype_force,

        current_date                                                 AS dokument_erstelldatum,

        anf_bisDatum                                                 AS dokument_faelligdatum,

        'trans.kopf.ihrangebot'::varchar(75)                         AS dokument_reftitkunde,
        'trans.kopf.unsereanfrage'::varchar(75)                      AS dokument_reftiteigen,
        null::char(1)                                                AS dokument_reftiteigen1,

        coalesce( anf_titel, 'trans.kopf.anfrage'::varchar(75) )     AS dokument_titel,
        'trans.kopf.anfrage'::varchar(75)                            AS dokument_titel_doktype,
        coalesce( anf_kopftext_rtf, anf_kopftext )                   AS dokument_kopftext,
        coalesce( anf_fusstext_rtf, anf_fusstext )                   AS dokument_fusstext,

        -- Q-Hint. Wenn nix gefunden wird, wird durch das coalesce automatisch der Standard-QHint geladen!
        belarzu__zu_tit__gettxt(
               'DOKEINKAUF_QHINT'
            || coalesce( '-' || anf_nident, ''),
            ReportLang_current()
        )                                                            AS dokument_qhint,

        null::text                                                   AS dokument_exporttxt,
        null::text                                                   AS dokument_exportursprungtxt,
        belarzu__zu_tit__gettxt(
            'DOKU_EMAILTXT',
            ReportLang_current(),
            false
        )                                                            AS dokument_emailtxt,

        -- eine gleiche referenz über alles?
        1                                                            AS dokument_positiongroupcount,

        alief_lkontaktkrz                                            AS dokument_adresse_ansprechpartner_adressant_ident,
        alief_lkontakt                                               AS dokument_adresse_ansprechpartner_adressant,
        ap_anr                                                       AS dokument_adresse_ansprechpartner_adressant_anr,
        ap_sex_man::varchar(1)                                       AS dokument_adresse_ansprechpartner_adressant_man,
        ap_name                                                      AS dokument_adresse_ansprechpartner_adressant_nachname,
        ap_vorn                                                      AS dokument_adresse_ansprechpartner_adressant_vorname,
        ap_sysfun                                                    AS dokument_adresse_ansprechpartner_adressant_sysfun,
        ap_titel                                                     AS dokument_adresse_ansprechpartner_adressant_titel,

        alief_lkn                                                    AS dokument_adresse_adressant,

        -- zB dbrid für Parameter
        adk_ad_krz                                                   AS dokument_adresse_ident,

        null::char(1)                                                AS ustidnr,

        null::float                                                  AS dokument_summe_netto,
        null::float                                                  AS dokument_summe_brutto,

        null::float                                                  AS dokument_fixwert,

        -- gesamtrabatt in rechnung muß bei position ausgewiesen werden, da mehrere aufträge kombiniert sein könnten
        null::float                                                  AS dokument_gesamtrabatt,
        null::float                                                  AS dokument_gesamtrabatt_wert,

        coalesce(
            to_char( anf_bisdatum, 'DD.MM.YY' ),
            anf_termweek
        )                                                            AS dokument_bindefrist,

        anf_apint                                                    AS dokument_adresse_ap_intern_ident,
        nameAufloesen( anf_apint )                                   AS dokument_adresse_ap_intern_name,
        null::char(1)                                                AS dokument_adresse_ap_intern_ident2,
        null::char(1)                                                AS dokument_adresse_ap_intern_name2,

        coalesce( ap_mail, ad_email1 )                               AS adresse_adressant_email,

        a2_knr::varchar(50)                                          AS dokument_adresse_knr_debi_or_kredi,
        a2_eknr::varchar(50)                                         AS dokument_adresse_adressant_knr_debi_or_kredi,
        anflief.alief_waer                                           AS zahlung_waco,
        a2_spco                                                      AS sprache_debi_or_kredi,
        a2_tolfrueh                                                  AS lieftolfrueh_debi_or_kredi,
        a2_tolspaet                                                  AS lieftolspaet_debi_or_kredi,
        null::boolean                                                AS euexport,
        null::boolean                                                AS intexport,

        -- ZAZ Nummer
        null::varchar                                                AS zazexport,
        -- EORI des Kunden
        null::varchar                                                AS eori_vertragspartner,

        coalesce( anf_zak, a2_zak, ( TAdk.StandardZak('E') ).zak )   AS zahlung_tage_zahlungbis,
        coalesce( anf_skv, a2_skv, ( TAdk.StandardZak('E') ).skv )   AS zahlung_tage_skontoverfall,
        coalesce( anf_sks, a2_sks, ( TAdk.StandardZak('E') ).sks )   AS zahlung_skontosatz_prozent,

        lang_za( a2_zahlart, ReportLang_current() )                  AS zahlung_zahlart_name_debikredidat,
        coalesce( anf_zakbem, null::char(1) )                        AS zahlung_zahlkondition_bemerkung,

        kto_bknr,
        kto_blz,
        kto_bank,
        kto_bic,
        kto_iban,
        kto_pckonto,
        kto_bb,

        -- Hintergrund-Einstellung aus Sprache
        (SELECT s_bb FROM adkspco WHERE a2_spco = s_spco)            AS s_bb,

        null::integer                                                AS versand_versandart_ident,

        -- neu #7137
        coalesce(
            lang_versart( v_id, ReportLang_current() ),
            anf_vers,
            a2_vers,
            ( TAdk.StandardZak('E') ).vers
        )                                                            AS versand_versandart,

        -- Ort des Gefahrenübergangs
        null::varchar                                                AS versand_versandort,
        coalesce(
            anf_versandbem_rtf,
            anf_versandbem,
            null::char(1)
        )                                                            AS versand_bem,

        -- Dokumenten-Versandbezeichnung Adressstammdaten
        (
            SELECT ( TAdk.DokVersandTyp( ad_dokversand ) ).ad_DokVersandBez
            FROM adk
            WHERE adk.ad_krz = adk_ad_krz
        )                                                            AS dokument_versand,

        1                                                            AS preiseinheit_max,
        -- Strukturposition
        1                                                            AS hwpos_max,
        -- Länge Bestellpostion Kunde #12607
        1                                                            AS bdapos_max,

        -- float cast wirft nachfolgende 0en weg  http://postgresql.1045698.n5.nabble.com/strip-zeros-from-fractional-part-td1849963.html
        (
            SELECT
                max(
                    numeric_larger(
                      length(
                          abs(
                              aart_menge - trunc( aart_menge )
                          )::float::varchar
                      )
                      - 2
                      ,
                      0
                    )
                )
            FROM anfart
            WHERE aart_anf_nr = anf_nr
        )                                                            AS dokument_menge_numdigits,

        0                                                            AS dokument_vkp_numdigits,
        2                                                            AS dokument_arab_numdigits
    FROM anfrage
    JOIN anflief ON alief_anf_nr = anf_nr
    -- wegen Debitorendaten
    LEFT JOIN adressen_view ON ad_krz = alief_lkn
    -- Kreditorendaten zur Adresse
    LEFT JOIN adk2 ON a2_krz = adk_ad_krz
    LEFT JOIN adkap ON
                    adk_ad_krz = ap_ad_krz
                AND ap_krzl = alief_lkontaktkrz
                AND ap_krzl IS NOT NULL
    LEFT JOIN ktovz ON kto_std

    -- LIKE-JOIN http://redmine.prodat-sql.de/issues/4981#note-6
    LEFT JOIN versart ON v_art ILIKE coalesce( anf_vers, a2_vers, ( TAdk.StandardZak('E') ).vers );


    DROP VIEW IF EXISTS treporting.anfrage_pos_abzu_pos;

  -- Hinweis: hält die Kontrollmerkmale. Wird alles sonst via Union zusammengesetzt. Siehe treporting.ldsdok_abzuschlaege_pos
    CREATE OR REPLACE VIEW treporting.anfrage_pos_abzu_pos AS
     SELECT
      aart_id                                              AS position_id,
      COALESCE(NullIf(TRIM(apr_doktxt), ''), apr_bez)      AS bezeichnung,
      NULL::CHAR(1)                                        AS typ,
      null::integer                                        AS pos,
      1                                                    AS anzahl,
      null::float                                          AS preis,
      null::float                                          AS preis_wert_netto,
      null::float                                          AS prozent,
      null::integer                                        AS steuercode,
      null::float                                          AS steuerprozent,
      TRUE                                                 AS sichtbar,
      null::text                                           AS bemerkung,    --- #20090
      null::char(1)                                        AS bemerkung_intern,
      0                                                    AS abzu_menge_numdigits,
      0                                                    AS abzu_preis_numdigits
     FROM anfart
     JOIN art ON ak_nr = aart_ak_nr
     JOIN artpruefung ON aart_ak_nr = apr_aknr OR ak_ac = apr_ac
     WHERE apr_aufdok;


    DROP VIEW IF EXISTS treporting.anfrage_abzu_kopf;

    CREATE OR REPLACE VIEW treporting.anfrage_abzu_kopf AS
    SELECT
       null::varchar              AS dokument_id,
       null::char(1)              AS bezeichnung,
       null::char(1)              AS typ,
       null::integer              AS pos,
       null::float                AS anzahl,
       null::float                AS preis,
       null::float                AS preis_wert_netto,
       null::float                AS prozent,
       null::integer              AS steuercode,
       null::float                AS steuerprozent,
       false                      AS sichtbar,
       null::char(1)              AS bemerkung,
       null::char(1)              AS bemerkung_intern
    ;


    DROP VIEW IF EXISTS treporting.anfrage_steuerartenbetrag;

    CREATE OR REPLACE VIEW treporting.anfrage_steuerartenbetrag AS
    SELECT
        0::varchar                                            AS dokument_id,
        -1                                                    AS steucode,
        0                                                     AS steuproz,
        0                                                     AS steubetrag,
        null::char(1)                                         AS steubez
     ;

END $$ LANGUAGE plpgsql;


-- SELECT TSystem.views__ReportingAnfrage__recreate();